/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.moduleviews;

import com.ldtteam.blockout.views.Window;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModuleView;
import com.minecolonies.coremod.client.gui.modules.WindowBuilderResModule;
import com.minecolonies.coremod.colony.buildings.utils.BuildingBuilderResource;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class BuildingResourcesModuleView
extends AbstractBuildingModuleView {
    private final HashMap<String, BuildingBuilderResource> resources = new HashMap();
    private String constructionName;
    private double progress;
    private int finishedStages = 0;
    private int totalStages = 1;

    @Override
    public void deserialize(@NotNull PacketBuffer buf) {
        int size = buf.readInt();
        this.resources.clear();
        for (int i = 0; i < size; ++i) {
            ItemStack itemStack = buf.func_150791_c();
            int amountAvailable = buf.readInt();
            int amountNeeded = buf.readInt();
            BuildingBuilderResource resource = new BuildingBuilderResource(itemStack, amountNeeded, amountAvailable);
            this.resources.put(itemStack.func_200301_q().getString(), resource);
        }
        this.constructionName = buf.func_150789_c(Short.MAX_VALUE);
        this.progress = buf.readDouble();
        this.totalStages = buf.readInt();
        this.finishedStages = buf.readInt();
    }

    public String getConstructionName() {
        return this.constructionName;
    }

    public Map<String, BuildingBuilderResource> getResources() {
        return Collections.unmodifiableMap(this.resources);
    }

    public int getProgress() {
        int localProgress = Math.max(100 - (int)(this.progress * 100.0), 0);
        if (this.finishedStages == 0 && this.totalStages == this.finishedStages) {
            return 0;
        }
        return localProgress;
    }

    public int getCurrentStage() {
        return this.finishedStages;
    }

    public int getTotalStages() {
        return this.totalStages;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Window getWindow() {
        return new WindowBuilderResModule("minecolonies:gui/layouthuts/layoutbuilderres.xml", this.buildingView, this);
    }

    @Override
    public String getIcon() {
        return "inventory";
    }

    @Override
    public String getDesc() {
        return "com.minecolonies.coremod.gui.workerhuts.resourcelist";
    }
}

